package fr.asip.cps3.exemple.controleurs;

import java.util.Vector;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.MenuApplication;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionControleur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;

/**
 * Contrleur d'application
 *
 */
public class ApplicationControleur {
	
	/**
	 * Le loggeur
	 */
	 private static Logger log = Logger.getLogger(ApplicationControleur.class);	
	
	/**
	 * Fentre principale de l'application
	 */
	public ApplicationVue fenetrePrincipale = null;
	
	/**
	 * L'application
	 */
	private Application application = null;
	
	/**
	 * Constructeur
	 * @param application L'application
	 * @throws ExceptionProgrammeExemple 
	 */
	public ApplicationControleur(Application application) throws ExceptionProgrammeExemple {
		
		fenetrePrincipale = new FenetrePrincipale(this,application);
		this.application = application;
		try {
			ajouteEcouteursApplication();
		} catch (ExceptionProgrammeExemple e) {
			throw e;
		}
		
	}
	
	/**
	 * Ajoute le(s) couteur(s) de l'application
	 * @throws ExceptionControleur 
	 */
	private void ajouteEcouteursApplication() throws ExceptionControleur{
		
		if(application != null)
			application.ajouteApplicationEcouteur(fenetrePrincipale);
		else {
			log.error("L'application vaut nul. Il est impossible d'ajouter des couteurs");
			throw new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_APPLICATION,"Une erreur inattendue est survenue");
		}
		
	}
	
	/**
	 * Affiche la fentre principale
	 * @throws ExceptionControleur 
	 */
	public void afficheFenetrePrincipale() throws ExceptionControleur {

		if(fenetrePrincipale != null)
			fenetrePrincipale.affiche();
		else {
			log.error("La fentre principale vaut nul. Il est impossible de l'afficher");
			throw new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_APPLICATION,"Une erreur inattendue est survenue");
		}
	}

	/**
	 * Ferme la fentre principale
	 * @throws ExceptionControleur 
	 */
	public void fermeFenetrePrincipale() throws ExceptionControleur {
		

		if(fenetrePrincipale != null)
			fenetrePrincipale.ferme();
		else {
			log.error("La fentre principale vaut nul. Il est impossible de la fermer");
			throw new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_APPLICATION,"Une erreur inattendue est survenue");
		}
		
	}
	
	/**
	 * Dclenche l'opration associ a l'Item menu cliqu
	 * @param source ItemMenu cliqu
	 */
	public void declencheOperationMenu(Object source) {
		
		MenuControleur.executeOperation(application,(ItemMenu)source);
		
	}

	/**
	 * Dclenche la validation de l'cran de saisie
	 * @param saisie L'cran de saisie contenant les arguments utiles  l'opration
	 * @return Liste des problmes de saisie
	 */
	public Vector<String> declencheValidationSaisie(Saisie saisie) {
		
		return EcranControleur.valideSaisie(application, saisie);
		
	}	
	
	/**
	 * Dclenche l'opration associ  la saisie
	 * @param saisie L'cran de saisie contenant les arguments utiles  l'opration
	 */
	public void declencheOperationSaisie(Saisie saisie) {
		
		EcranControleur.executeOperation(application, saisie);
		
	}

	/**
	 * Dclenche le chargement de la librairie
	 * @param chemin Chemin de la librairie
	 * @throws ExceptionControleur 
	 */
	public void declencheChargementLibrairie(String chemin) throws ExceptionControleur {

		if(application != null) {
			application.setLibrairieP11(chemin);
			application.supprimeTousLesElementsEnCours();
			MenuControleur.refresh(application,MenuApplication.OPTIONS_CHARGELIB);
		} else {
			log.error("L'application vaut nul. Il est impossible de dclencher le chargement de la librairie");
			throw new ExceptionControleur(ExceptionProgrammeExemple.TYPE_CONTROLEUR_APPLICATION,"Une erreur inattendue est survenue");
		}
		
	}

	/**
	 * Dvrouille le menu
	 */
	public void deverrouilleMenu() {

		MenuControleur.deverrouille(application);
		
	}
	
	/**
	 * Vrouille le menu
	 */
	public void verrouilleMenu() {

		MenuControleur.verrouille(application);
		
	}	

}
